<?php

namespace App\Controllers;

use App\Libraries\PanelAPI;

class Station extends BaseController {
    
    public function __construct(){
        $this->panel = new PanelAPI();
    }
    
    public function index() {
        return redirect()->to(base_url());
    }
    
    public function radio_id($name, $id) {
        
        $row_data = $this->panel->getRadioId($id);
        
        $mata_title = (empty($row_data) ? '' : $row_data['radio_list'][0]['radio_title']);
        $mata_cat = (empty($row_data) ? '' : $row_data['radio_list'][0]['category_name']);
        
        $data = [
            'mataTitle' => $mata_title,
            'menu_active' => '',
            'mata_description' => "Listen to " .$mata_title ."( " .$mata_cat ." ) " ." | "
            
        ];
        
        $data['radio_data'] = $row_data;

        $data['details'] = $this->panel->getWebDetails();
        $data['sidebar']  = $this->panel->getSidebar();
        return view('station', $data);
    }
    
    public function embedded_index($id){
        
        $row_data = $this->panel->getRadioId($id);
        
        if($row_data){
            
            $mata_title = (empty($row_data) ? '' : $row_data[0]['radio_title']);
            $mata_cat = (empty($row_data) ? '' : $row_data[0]['category_name']);
            
            $data = [
                'mataTitle' => $mata_title,
                'menu_active' => '',
                'mata_description' => "Listen to " .$mata_title ."( " .$mata_cat ." ) " ." | "
            ];
            
            $data['radio_data'] = $row_data;
            
            $data['details'] = $this->panel->getWebDetails();
            $data['sidebar']  = $this->panel->getSidebar();
            return view('embedded', $data);
            
        } else {
            return redirect()->to(base_url());
        }
    }
    
    public function podcast_id($id) {
        
        $data = [
            'mataTitle' => 'Episode',
            'menu_active' => ''
        ];
        
        $data['episode_data'] = $this->panel->getPodcastBy($id);
        
        $data['details'] = $this->panel->getWebDetails();
        $data['sidebar']  = $this->panel->getSidebar();
        return view('episode', $data);
    }
    
    // for increment product views
    public function update_view($id){
        $data = update_total_views($id);
    }
}
